<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Seller extends Model 
{

    protected $table = 'sellers';
    public $timestamps = true;
    protected $fillable = array('promo_code', 'user_name', 'email', 'f_b_page', 'password');

    public function products()
    {
        return $this->hasMany('App\Models\Product');
    }

    public function favoriteDeliveries()
    {
        return $this->belongsToMany('App\Models\Delivery');
    }

    public function reviews()
    {
        return $this->morphMany('App\Models\Review');
    }

    public function orders()
    {
        return $this->morphMany('App\Models\Order');
    }

    public function addresses()
    {
        return $this->morphMany('App\Models\Address');
    }

    public function contacts()
    {
        return $this->hasMany('App\Models\Contact');
    }

}